"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AliasSpecifier = void 0;
const effect_1 = require("effect");
const _1 = require(".");
const base_1 = require("./base");
const non_semver_error_1 = require("./lib/non-semver-error");
/** @example "npm:imageoptim-cli@3.1.7" */
class AliasSpecifier extends base_1.BaseSpecifier {
    _tag = 'Alias';
    /** The public name referenced in config */
    name = 'alias';
    /** Return the version portion if it is valid semver */
    getSemver() {
        return (0, effect_1.pipe)(this.parse(), effect_1.Effect.mapError(() => new non_semver_error_1.NonSemverError({ specifier: this })), effect_1.Effect.map((parsed) => parsed.subSpec), effect_1.Effect.flatMap((subSpec) => ['range', 'version'].includes(subSpec.type) && subSpec.fetchSpec !== null
            ? effect_1.Effect.succeed(subSpec.fetchSpec)
            : non_semver_error_1.NonSemverError.asEffect(this)));
    }
    /** Get a new `Specifier` from the given semver version applied to this one */
    setSemver(version) {
        return (0, effect_1.pipe)(this.parse(), effect_1.Effect.mapError(() => new non_semver_error_1.NonSemverError({ specifier: this })), effect_1.Effect.map((parsed) => parsed.subSpec), effect_1.Effect.map((subSpec) => subSpec.name || ''), effect_1.Effect.map((name) => `npm:${name}@${version}`), effect_1.Effect.map((raw) => _1.Specifier.create(this.instance, raw)));
    }
}
exports.AliasSpecifier = AliasSpecifier;
