import { Effect } from 'effect';
import type { AliasResult } from 'npm-package-arg';
import { Specifier } from '.';
import { BaseSpecifier } from './base';
import { NonSemverError } from './lib/non-semver-error';
type T = AliasResult;
/** @example "npm:imageoptim-cli@3.1.7" */
export declare class AliasSpecifier extends BaseSpecifier<T> {
    _tag: string;
    /** The public name referenced in config */
    name: "alias";
    /** Return the version portion if it is valid semver */
    getSemver(): Effect.Effect<never, NonSemverError, string>;
    /** Get a new `Specifier` from the given semver version applied to this one */
    setSemver(version: string): Effect.Effect<never, NonSemverError, Specifier.Any>;
}
export {};
