"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WithRangeSemverGroup = void 0;
const effect_1 = require("effect");
const set_semver_range_1 = require("../lib/set-semver-range");
const report_1 = require("../report");
const specifier_1 = require("../specifier");
class WithRangeSemverGroup extends effect_1.Data.TaggedClass('WithRange') {
    groupType = 'semverGroup';
    constructor(isCatchAll, config) {
        super({
            config,
            instances: [],
            isCatchAll,
        });
        this.getFixed = this.getFixed.bind(this);
    }
    canAdd(_) {
        return true;
    }
    getFixed(specifier) {
        return (0, effect_1.pipe)(specifier.getSemver(), effect_1.Effect.map((semver) => (0, set_semver_range_1.setSemverRange)(this.config.range, semver)), effect_1.Effect.flatMap((nextSemver) => specifier.setSemver(nextSemver)));
    }
    inspectAll() {
        return effect_1.Effect.all(this.instances.map((instance) => this.inspect(instance)));
    }
    inspect(instance) {
        const current = specifier_1.Specifier.create(instance, instance.rawSpecifier.raw);
        return (0, effect_1.pipe)(this.getFixed(current), effect_1.Effect.match({
            // if range is fixable
            onSuccess: (valid) => 
            // if it is pinned and matches its pin
            instance.versionGroup._tag === 'Pinned' &&
                instance.rawSpecifier.raw === instance.versionGroup.config.pinVersion
                ? // the pinned version takes precendence and is a match
                    new report_1.Report.Valid(current)
                : // if it is already like this on disk
                    instance.rawSpecifier.raw === valid.raw
                        ? // it is a match
                            new report_1.Report.Valid(current)
                        : // it is a mismatch and should be this one
                            new report_1.Report.SemverRangeMismatch(valid),
            // if range is NOT fixable, it is a mismatch we can't auto-fix
            // as it seems to not be semver
            onFailure: () => new report_1.Report.UnsupportedMismatch(instance),
        }));
    }
}
exports.WithRangeSemverGroup = WithRangeSemverGroup;
