import { Data, Effect } from 'effect';
import type { SemverGroupConfig } from '../config/types';
import type { Instance } from '../get-instances/instance';
import { Report } from '../report';
import { Specifier } from '../specifier';
import type { NonSemverError } from '../specifier/lib/non-semver-error';
declare const WithRangeSemverGroup_base: new <A extends Record<string, any> = {}>(args: import("effect/Types").Equals<Omit<A, keyof import("effect/Equal").Equal>, {}> extends true ? void : { readonly [P in keyof A as P extends "_tag" | keyof import("effect/Equal").Equal ? never : P]: A[P]; }) => Data.Data<Readonly<A> & {
    readonly _tag: "WithRange";
}>;
export declare class WithRangeSemverGroup extends WithRangeSemverGroup_base<{
    config: SemverGroupConfig.WithRange;
    instances: Instance[];
    isCatchAll: boolean;
}> {
    groupType: string;
    constructor(isCatchAll: boolean, config: SemverGroupConfig.WithRange);
    canAdd(_: Instance): boolean;
    getFixed(specifier: Specifier.Any): Effect.Effect<never, NonSemverError, Specifier.Any>;
    inspectAll(): Effect.Effect<never, never, (Report.SemverRangeMismatch | Report.UnsupportedMismatch | Report.Valid)[]>;
    inspect(instance: Instance): Effect.Effect<never, never, Report.UnsupportedMismatch | Report.SemverRangeMismatch | Report.Valid>;
}
export {};
