"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IgnoredSemverGroup = void 0;
const effect_1 = require("effect");
const report_1 = require("../report");
/** Every instance in this group is ignored and nothing will be changed */
class IgnoredSemverGroup extends effect_1.Data.TaggedClass('Ignored') {
    groupType = 'semverGroup';
    constructor(config) {
        super({
            config,
            instances: [],
        });
    }
    canAdd(_) {
        return true;
    }
    getFixed(specifier) {
        return effect_1.Effect.succeed(specifier);
    }
    inspectAll() {
        return effect_1.Effect.all(this.instances.map((instance) => this.inspect(instance)));
    }
    inspect(instance) {
        return effect_1.Effect.succeed(new report_1.Report.Ignored(instance));
    }
}
exports.IgnoredSemverGroup = IgnoredSemverGroup;
