import { Data, Effect } from 'effect';
import type { SemverGroupConfig } from '../config/types';
import type { Instance } from '../get-instances/instance';
import { Report } from '../report';
import type { Specifier } from '../specifier';
import type { NonSemverError } from '../specifier/lib/non-semver-error';
declare const IgnoredSemverGroup_base: new <A extends Record<string, any> = {}>(args: import("effect/Types").Equals<Omit<A, keyof import("effect/Equal").Equal>, {}> extends true ? void : { readonly [P in keyof A as P extends "_tag" | keyof import("effect/Equal").Equal ? never : P]: A[P]; }) => Data.Data<Readonly<A> & {
    readonly _tag: "Ignored";
}>;
/** Every instance in this group is ignored and nothing will be changed */
export declare class IgnoredSemverGroup extends IgnoredSemverGroup_base<{
    config: SemverGroupConfig.Ignored;
    instances: Instance[];
}> {
    groupType: string;
    constructor(config: SemverGroupConfig.Ignored);
    canAdd(_: Instance): boolean;
    getFixed(specifier: Specifier.Any): Effect.Effect<never, NonSemverError, Specifier.Any>;
    inspectAll(): Effect.Effect<never, never, Report.Ignored[]>;
    inspect(instance: Instance): Effect.Effect<never, never, Report.Ignored>;
}
export {};
