"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FilteredOutSemverGroup = void 0;
const effect_1 = require("effect");
const get_filter_1 = require("../config/get-filter");
const report_1 = require("../report");
/**
 * Instances which do not match a given `--filter` option are assigned to this
 * group and nothing will be changed.
 */
class FilteredOutSemverGroup extends effect_1.Data.TaggedClass('FilteredOut') {
    groupType = 'semverGroup';
    constructor(ctx) {
        super({
            config: {
                dependencies: ['**'],
                dependencyTypes: ['**'],
                label: 'Filtered out',
                packages: ['**'],
            },
            filter: (0, get_filter_1.getFilter)(ctx.config),
            instances: [],
        });
    }
    canAdd(instance) {
        return instance.name.search(new RegExp(this.filter)) === -1;
    }
    getFixed(specifier) {
        return effect_1.Effect.succeed(specifier);
    }
    inspectAll() {
        return effect_1.Effect.all(this.instances.map((instance) => this.inspect(instance)));
    }
    inspect(instance) {
        return effect_1.Effect.succeed(new report_1.Report.FilteredOut(instance));
    }
}
exports.FilteredOutSemverGroup = FilteredOutSemverGroup;
