import { Data, Effect } from 'effect';
import type { GroupConfig } from '../config/types';
import type { Ctx } from '../get-context';
import type { Instance } from '../get-instances/instance';
import { Report } from '../report';
import type { Specifier } from '../specifier';
import type { NonSemverError } from '../specifier/lib/non-semver-error';
declare const FilteredOutSemverGroup_base: new <A extends Record<string, any> = {}>(args: import("effect/Types").Equals<Omit<A, keyof import("effect/Equal").Equal>, {}> extends true ? void : { readonly [P in keyof A as P extends "_tag" | keyof import("effect/Equal").Equal ? never : P]: A[P]; }) => Data.Data<Readonly<A> & {
    readonly _tag: "FilteredOut";
}>;
/**
 * Instances which do not match a given `--filter` option are assigned to this
 * group and nothing will be changed.
 */
export declare class FilteredOutSemverGroup extends FilteredOutSemverGroup_base<{
    config: GroupConfig;
    filter: string;
    instances: Instance[];
}> {
    groupType: string;
    constructor(ctx: Ctx);
    canAdd(instance: Instance): boolean;
    getFixed(specifier: Specifier.Any): Effect.Effect<never, NonSemverError, Specifier.Any>;
    inspectAll(): Effect.Effect<never, never, Report.FilteredOut[]>;
    inspect(instance: Instance): Effect.Effect<never, never, Report.FilteredOut>;
}
export {};
