"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DisabledSemverGroup = void 0;
const effect_1 = require("effect");
const report_1 = require("../report");
/**
 * Semver groups are disabled by default and, when that's the case, every
 * instance is assigned to this group. This group will allow anything.
 */
class DisabledSemverGroup extends effect_1.Data.TaggedClass('Disabled') {
    groupType = 'semverGroup';
    constructor(isCatchAll, config) {
        super({
            config,
            instances: [],
            isCatchAll,
        });
    }
    canAdd(_) {
        return true;
    }
    getFixed(specifier) {
        return effect_1.Effect.succeed(specifier);
    }
    inspectAll() {
        return effect_1.Effect.all(this.instances.map((instance) => this.inspect(instance)));
    }
    inspect(instance) {
        return effect_1.Effect.succeed(new report_1.Report.Disabled(instance));
    }
}
exports.DisabledSemverGroup = DisabledSemverGroup;
