import { Data, Effect } from 'effect';
import type { SemverGroupConfig } from '../config/types';
import type { Instance } from '../get-instances/instance';
import { Report } from '../report';
import type { Specifier } from '../specifier';
import type { NonSemverError } from '../specifier/lib/non-semver-error';
declare const DisabledSemverGroup_base: new <A extends Record<string, any> = {}>(args: import("effect/Types").Equals<Omit<A, keyof import("effect/Equal").Equal>, {}> extends true ? void : { readonly [P in keyof A as P extends "_tag" | keyof import("effect/Equal").Equal ? never : P]: A[P]; }) => Data.Data<Readonly<A> & {
    readonly _tag: "Disabled";
}>;
/**
 * Semver groups are disabled by default and, when that's the case, every
 * instance is assigned to this group. This group will allow anything.
 */
export declare class DisabledSemverGroup extends DisabledSemverGroup_base<{
    config: SemverGroupConfig.Disabled;
    instances: Instance[];
    isCatchAll: boolean;
}> {
    groupType: string;
    constructor(isCatchAll: boolean, config: SemverGroupConfig.Disabled);
    canAdd(_: Instance): boolean;
    getFixed(specifier: Specifier.Any): Effect.Effect<never, NonSemverError, Specifier.Any>;
    inspectAll(): Effect.Effect<never, never, Report.Disabled[]>;
    inspect(instance: Instance): Effect.Effect<never, never, Report.Disabled>;
}
export {};
