"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.withLogger = void 0;
const chalk_1 = __importDefault(require("chalk"));
const effect_1 = require("effect");
function withLogger(program) {
    const logger = effect_1.Logger.make(({ logLevel, message }) => {
        if (logLevel === effect_1.LogLevel.Info) {
            globalThis.console.info(message);
        }
        else if (logLevel === effect_1.LogLevel.Debug) {
            globalThis.console.info((0, chalk_1.default) `{magenta ? %s}`, message);
        }
        else if (logLevel === effect_1.LogLevel.Error) {
            globalThis.console.error((0, chalk_1.default) `{red ! %s}`, message);
        }
        else if (logLevel === effect_1.LogLevel.Warning) {
            globalThis.console.warn((0, chalk_1.default) `{yellow ! %s}`, message);
        }
        else {
            globalThis.console.log((0, chalk_1.default) `{cyan [%s] %s}`, logLevel, message);
        }
    });
    const layer = effect_1.Logger.replace(effect_1.Logger.defaultLogger, logger);
    const logLevel = process.env.SYNCPACK_VERBOSE === 'true'
        ? effect_1.LogLevel.Debug
        : process.env.NODE_ENV === 'test'
            ? effect_1.LogLevel.None
            : effect_1.LogLevel.Info;
    return effect_1.Effect.provide(effect_1.Logger.withMinimumLogLevel(program, logLevel), layer);
}
exports.withLogger = withLogger;
