"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setSemverRange = void 0;
const is_string_1 = require("tightrope/guard/is-string");
const constants_1 = require("../constants");
const is_semver_1 = require("../guards/is-semver");
const is_valid_semver_range_1 = require("../guards/is-valid-semver-range");
/** @deprecated migrate to make better use of npm-package-arg */
function setSemverRange(semverRange, version) {
    if (!(0, is_semver_1.isSemver)(version) || !(0, is_valid_semver_range_1.isValidSemverRange)(semverRange))
        return version;
    if (semverRange === '*')
        return semverRange;
    const nextVersion = isLooseSemver(version) ? version.replace(/\.x/g, '.0') : version;
    const from1stNumber = nextVersion.search(/[0-9]/);
    const from1stDot = nextVersion.indexOf('.');
    return semverRange === constants_1.RANGE.LOOSE
        ? `${nextVersion.slice(from1stNumber, from1stDot)}.x.x`
        : `${semverRange}${nextVersion.slice(from1stNumber)}`;
}
exports.setSemverRange = setSemverRange;
function isLooseSemver(version) {
    return (0, is_string_1.isString)(version) && (0, is_semver_1.isSemver)(version) && version.search(/\.x(\.|$)/) !== -1;
}
