"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getVersionGroupHeader = exports.getSemverGroupHeader = void 0;
const chalk_1 = __importDefault(require("chalk"));
function getSemverGroupHeader(input) {
    return getGroupHeader(input.group.config.label || `Semver Group ${input.index + 1}`);
}
exports.getSemverGroupHeader = getSemverGroupHeader;
function getVersionGroupHeader(input) {
    return getGroupHeader(input.group.config.label || `Version Group ${input.index + 1}`);
}
exports.getVersionGroupHeader = getVersionGroupHeader;
function getGroupHeader(label) {
    const trimmed = label.trim();
    const hasNewLines = trimmed.search(/[\r\n]/) !== -1;
    const header = hasNewLines ? formatMultiLine(trimmed) : formatSingleLine(trimmed);
    return chalk_1.default.blue(header);
}
function formatSingleLine(label) {
    const leftSide = `= ${label} `;
    const dividerWidth = 80 - leftSide.length;
    const rightSide = dividerWidth > 0 ? '='.repeat(dividerWidth) : '';
    return `${leftSide}${rightSide}`;
}
function formatMultiLine(label) {
    const reindented = label.replace(/^\s+/gm, '  ');
    return `= ${reindented}`;
}
