"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.writeIfChanged = void 0;
const chalk_1 = __importDefault(require("chalk"));
const effect_1 = require("effect");
const constants_1 = require("../constants");
const to_json_1 = require("./to-json");
const write_file_sync_1 = require("./write-file-sync");
function writeIfChanged(ctx) {
    return (0, effect_1.pipe)(effect_1.Effect.all(ctx.packageJsonFiles.map((file) => (0, effect_1.pipe)(effect_1.Effect.Do, effect_1.Effect.bind('nextJson', () => effect_1.Effect.succeed((0, to_json_1.toJson)(ctx, file))), effect_1.Effect.bind('hasChanged', ({ nextJson }) => effect_1.Effect.succeed(file.jsonFile.json !== nextJson)), effect_1.Effect.flatMap(({ hasChanged, nextJson }) => hasChanged
        ? (0, effect_1.pipe)((0, write_file_sync_1.writeFileSync)(file.jsonFile.filePath, nextJson), effect_1.Effect.flatMap(() => effect_1.Effect.logInfo((0, chalk_1.default) `{green ${constants_1.ICON.tick}} ${file.jsonFile.shortPath}`)))
        : effect_1.Effect.logInfo((0, chalk_1.default) `{dim ${constants_1.ICON.skip} ${file.jsonFile.shortPath}}`))))), effect_1.Effect.map(() => ctx));
}
exports.writeIfChanged = writeIfChanged;
