"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.writeFileSync = exports.WriteFileError = void 0;
const effect_1 = require("effect");
const _1 = require(".");
class WriteFileError extends effect_1.Data.TaggedClass('WriteFileError') {
}
exports.WriteFileError = WriteFileError;
function writeFileSync(filePath, contents) {
    return (0, effect_1.pipe)(_1.IoTag, effect_1.Effect.flatMap((io) => effect_1.Effect.try({
        try: () => io.fs.writeFileSync(filePath, contents),
        catch: (err) => new WriteFileError({ filePath, error: String(err) }),
    })));
}
exports.writeFileSync = writeFileSync;
