"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toJson = exports.newlines = void 0;
const os_1 = require("os");
const get_indent_1 = require("../config/get-indent");
const CR = '\r';
const CRLF = '\r\n';
const LF = '\n';
exports.newlines = {
    detect(source) {
        const cr = source.split(CR).length;
        const lf = source.split(LF).length;
        const crlf = source.split(CRLF).length;
        if (cr + lf === 0)
            return os_1.EOL;
        if (crlf === cr && crlf === lf)
            return CRLF;
        if (cr > lf)
            return CR;
        return LF;
    },
    fix(source, lineEnding) {
        return source.replace(/\r\n|\n|\r/g, lineEnding);
    },
};
function toJson(ctx, file) {
    const contents = file.jsonFile.contents;
    const indent = (0, get_indent_1.getIndent)(ctx.config);
    const EOL = exports.newlines.detect(file.jsonFile.json);
    const source = `${JSON.stringify(contents, null, indent)}${EOL}`;
    return exports.newlines.fix(source, EOL);
}
exports.toJson = toJson;
