"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readYamlFileSync = void 0;
const effect_1 = require("effect");
class ReadYamlFileError extends effect_1.Data.TaggedClass('ReadYamlFileError') {
}
function readYamlFileSync(io, filePath) {
    return effect_1.Effect.try({
        try: () => io.readYamlFile.sync(filePath),
        catch: (err) => new ReadYamlFileError({ filePath, error: String(err) }),
    });
}
exports.readYamlFileSync = readYamlFileSync;
