"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readJsonFileSync = exports.JsonFile = exports.JsonParseError = void 0;
const effect_1 = require("effect");
const path_1 = require("path");
const read_file_sync_1 = require("./read-file-sync");
class JsonParseError extends effect_1.Data.TaggedClass('JsonParseError') {
}
exports.JsonParseError = JsonParseError;
class JsonFile extends effect_1.Data.TaggedClass('JsonFile') {
}
exports.JsonFile = JsonFile;
function readJsonFileSync(io, filePath) {
    return (0, effect_1.pipe)(effect_1.Effect.Do, effect_1.Effect.bind('json', () => (0, read_file_sync_1.readFileSync)(io, filePath)), effect_1.Effect.bind('contents', ({ json }) => effect_1.Effect.try({
        try: () => JSON.parse(json),
        catch: (error) => new JsonParseError({ error, filePath, json }),
    })), effect_1.Effect.map(({ contents, json }) => new JsonFile({
        contents,
        dirPath: (0, path_1.dirname)(filePath),
        filePath,
        json,
        shortPath: (0, path_1.relative)(io.process.cwd(), filePath),
    })));
}
exports.readJsonFileSync = readJsonFileSync;
