"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readFileSync = exports.ReadFileError = void 0;
const effect_1 = require("effect");
class ReadFileError extends effect_1.Data.TaggedClass('ReadFileError') {
}
exports.ReadFileError = ReadFileError;
function readFileSync(io, filePath) {
    return effect_1.Effect.try({
        try: () => io.fs.readFileSync(filePath, { encoding: 'utf8' }),
        catch: (err) => new ReadFileError({ filePath, error: String(err) }),
    });
}
exports.readFileSync = readFileSync;
