"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readConfigFileSync = void 0;
const effect_1 = require("effect");
const path_1 = require("path");
const is_non_empty_object_1 = require("tightrope/guard/is-non-empty-object");
const read_json_file_sync_1 = require("./read-json-file-sync");
const getOptionOfNonEmptyObject = effect_1.Option.liftPredicate((is_non_empty_object_1.isNonEmptyObject));
function readConfigFileSync(io, configPath) {
    return (0, effect_1.pipe)(effect_1.Effect.try(() => io.cosmiconfig.cosmiconfig('syncpack')), effect_1.Effect.flatMap((client) => effect_1.Effect.tryPromise(() => (configPath ? client.load(configPath) : client.search()))), effect_1.Effect.flatMap((result) => result !== null ? getValueFromCosmiconfig(result) : findConfigInPackageJson(io)), effect_1.Effect.tap((config) => effect_1.Effect.logDebug(`config file found: ${JSON.stringify(config)}`)), effect_1.Effect.tapError(() => effect_1.Effect.logDebug('no config file found, will use defaults')), effect_1.Effect.catchAll(() => effect_1.Effect.succeed({})));
}
exports.readConfigFileSync = readConfigFileSync;
/**
 * Look for a .config.syncpack property in the root package.json.
 * @see https://github.com/JamieMason/syncpack/issues/86
 */
function findConfigInPackageJson(io) {
    return (0, effect_1.pipe)(effect_1.Effect.Do, effect_1.Effect.bind('rcPath', () => effect_1.Effect.succeed((0, path_1.join)(io.process.cwd(), 'package.json'))), effect_1.Effect.bind('packageJson', ({ rcPath }) => (0, read_json_file_sync_1.readJsonFileSync)(io, rcPath)), effect_1.Effect.bind('config', ({ packageJson }) => effect_1.Effect.try(() => packageJson.contents?.config?.syncpack)), effect_1.Effect.flatMap(({ config }) => getOptionOfNonEmptyObject(config)), effect_1.Effect.tapBoth({
        onSuccess: () => effect_1.Effect.logDebug('config found in <package.json>.config.syncpack'),
        onFailure: () => effect_1.Effect.logDebug('config not found in <package.json>.config.syncpack'),
    }));
}
/** Extract the value from a successful search by cosmiconfig */
function getValueFromCosmiconfig(result) {
    return (0, effect_1.pipe)(effect_1.Effect.succeed(result), effect_1.Effect.tap((result) => effect_1.Effect.logDebug(`cosmiconfig found ${result.filepath}`)), effect_1.Effect.flatMap((result) => getOptionOfNonEmptyObject(result.config)));
}
