"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.globSync = exports.GlobError = void 0;
const effect_1 = require("effect");
class GlobError extends effect_1.Data.TaggedClass('GlobError') {
}
exports.GlobError = GlobError;
function globSync(io, patterns) {
    return effect_1.Effect.try({
        try: () => io.globby.sync(patterns, {
            absolute: true,
            cwd: io.process.cwd(),
            fs: io.fs,
            ignore: ['**/node_modules/**'],
        }),
        catch: (err) => new GlobError({ error: String(err) }),
    });
}
exports.globSync = globSync;
