"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.askForInput = void 0;
const effect_1 = require("effect");
const _1 = require(".");
class AskForInputError extends effect_1.Data.TaggedClass('AskForInputError') {
}
function askForInput(opts) {
    return (0, effect_1.pipe)(_1.IoTag, effect_1.Effect.flatMap((io) => effect_1.Effect.tryPromise({
        try: () => io.enquirer.prompt({
            name: 'version',
            type: 'input',
            message: opts.message,
        }),
        catch: (err) => new AskForInputError({ error: String(err) }),
    })));
}
exports.askForInput = askForInput;
