"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.askForChoice = void 0;
const effect_1 = require("effect");
const _1 = require(".");
class AskForChoiceError extends effect_1.Data.TaggedClass('AskForChoiceError') {
}
function askForChoice(opts) {
    return (0, effect_1.pipe)(_1.IoTag, effect_1.Effect.flatMap((io) => effect_1.Effect.tryPromise({
        try: () => io.enquirer
            .prompt({
            type: 'select',
            name: 'choice',
            message: opts.message,
            choices: opts.choices,
        })
            .then((res) => res.choice),
        catch: (err) => new AskForChoiceError({ error: String(err) }),
    })));
}
exports.askForChoice = askForChoice;
