"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isSemver = void 0;
const is_string_1 = require("tightrope/guard/is-string");
/** @deprecated migrate to make better use of npm-package-arg */
function isSemver(version) {
    const range = '(~|\\^|>=|>|<=|<)?';
    const ints = '[0-9]+';
    const intsOrX = '([0-9]+|x)';
    const dot = '\\.';
    const major = new RegExp(`^${range}${ints}$`);
    const minor = new RegExp(`^${range}${ints}${dot}${intsOrX}$`);
    const patch = new RegExp(`^${range}${ints}${dot}${intsOrX}${dot}${intsOrX}$`);
    return ((0, is_string_1.isString)(version) &&
        (version.search(major) !== -1 || version.search(minor) !== -1 || version.search(patch) !== -1));
}
exports.isSemver = isSemver;
