"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.canAddToGroup = void 0;
const minimatch_1 = require("minimatch");
const is_non_empty_array_1 = require("tightrope/guard/is-non-empty-array");
function canAddToGroup(packageJsonFilesByName, group, instance) {
    const { dependencies, dependencyTypes, packages, specifierTypes } = group.config;
    return (group.canAdd(instance) &&
        matchesDependencyTypes(dependencyTypes, instance) &&
        matchesPackages(packages, instance) &&
        matchesDependencies(packageJsonFilesByName, group, dependencies, instance) &&
        matchesSpecifierTypes(specifierTypes, instance));
}
exports.canAddToGroup = canAddToGroup;
function matchesDependencies(packageJsonFilesByName, group, dependencies, instance) {
    // matches if not defined
    if (!(0, is_non_empty_array_1.isNonEmptyArray)(dependencies))
        return true;
    return dependencies.some((pattern) => (pattern === '$LOCAL' &&
        instance.name in packageJsonFilesByName &&
        ((group.groupType === 'versionGroup' && instance.versionGroup === null) ||
            (group.groupType === 'semverGroup' && instance.semverGroup === null))) ||
        (0, minimatch_1.minimatch)(instance.name, pattern));
}
function matchesPackages(packages, instance) {
    // matches if not defined
    if (!(0, is_non_empty_array_1.isNonEmptyArray)(packages))
        return true;
    return packages.some((pattern) => (0, minimatch_1.minimatch)(instance.pkgName, pattern));
}
function matchesDependencyTypes(dependencyTypes, instance) {
    return matchesKnownList(dependencyTypes, instance.strategy.name);
}
function matchesSpecifierTypes(specifierTypes, instance) {
    return matchesKnownList(specifierTypes, instance.rawSpecifier.name);
}
function matchesKnownList(values, value) {
    // matches if not defined
    if (!(0, is_non_empty_array_1.isNonEmptyArray)(values))
        return true;
    if (values.join('') === '**')
        return true;
    const negative = [];
    const positive = [];
    values.forEach((name) => {
        if (name.startsWith('!')) {
            negative.push(name.replace('!', ''));
        }
        else {
            positive.push(name);
        }
    });
    if ((0, is_non_empty_array_1.isNonEmptyArray)(negative) && !negative.includes(value))
        return true;
    return (0, is_non_empty_array_1.isNonEmptyArray)(positive) && positive.includes(value);
}
