"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PackageJsonFile = void 0;
const effect_1 = require("effect");
const instance_1 = require("../get-instances/instance");
class PackageJsonFile {
    /** resolved configuration */
    config;
    /** ensure only one set of instances is ever created and shared */
    _instances;
    /** the wrapped package.json file */
    jsonFile;
    /** the .name property from the package.json file */
    name;
    constructor(jsonFile, config) {
        this._instances = null;
        this.config = config;
        this.jsonFile = jsonFile;
        this.name = jsonFile.contents.name;
    }
    getInstances(enabledTypes) {
        if (!this._instances) {
            return (0, effect_1.pipe)(effect_1.Effect.all(enabledTypes.map((strategy) => (0, effect_1.pipe)(strategy.read(this), effect_1.Effect.map((entries) => entries.map(([name, rawSpecifier]) => new instance_1.Instance(name, rawSpecifier, this, strategy)))))), effect_1.Effect.map((array) => array.flat()), effect_1.Effect.tapBoth({
                onSuccess: (instances) => effect_1.Effect.logDebug(`found ${instances.length} instances in <${this.jsonFile.shortPath}>`),
                onFailure: () => effect_1.Effect.logError(`failed to get instances from <${this.jsonFile.shortPath}>`),
            }), effect_1.Effect.catchAll(() => effect_1.Effect.succeed([])), effect_1.Effect.tap((instances) => effect_1.Effect.sync(() => {
                this._instances = instances;
            })));
        }
        return effect_1.Effect.succeed(this._instances);
    }
}
exports.PackageJsonFile = PackageJsonFile;
