"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPackageJsonFiles = void 0;
const effect_1 = require("effect");
const read_json_file_sync_1 = require("../io/read-json-file-sync");
const get_file_paths_1 = require("./get-file-paths");
const package_json_file_1 = require("./package-json-file");
/** Create an API for every package.json file needed. */
function getPackageJsonFiles(io, config) {
    return (0, effect_1.pipe)((0, get_file_paths_1.getFilePaths)(io, config), effect_1.Effect.flatMap((filePaths) => effect_1.Effect.all(filePaths.map((filePath) => (0, read_json_file_sync_1.readJsonFileSync)(io, filePath)))), effect_1.Effect.map((files) => files.map((file) => new package_json_file_1.PackageJsonFile(file, config))), effect_1.Effect.tap((files) => effect_1.Effect.logDebug(`${files.length} package.json files found`)));
}
exports.getPackageJsonFiles = getPackageJsonFiles;
