import { Effect } from 'effect';
import type { Ctx } from '../get-context';
import type { Io } from '../io';
import type { GlobError } from '../io/glob-sync';
import type { ReadFileError } from '../io/read-file-sync';
import type { JsonParseError } from '../io/read-json-file-sync';
import type { NoSourcesFoundError } from './get-file-paths';
import { PackageJsonFile } from './package-json-file';
/** Create an API for every package.json file needed. */
export declare function getPackageJsonFiles(io: Io, config: Ctx['config']): Effect.Effect<never, NoSourcesFoundError | GlobError | ReadFileError | JsonParseError, PackageJsonFile[]>;
