"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPatterns = void 0;
const effect_1 = require("effect");
const is_array_of_strings_1 = require("tightrope/guard/is-array-of-strings");
const get_source_1 = require("../../config/get-source");
const constants_1 = require("../../constants");
const get_lerna_patterns_1 = require("./get-lerna-patterns");
const get_pnpm_patterns_1 = require("./get-pnpm-patterns");
const get_yarn_patterns_1 = require("./get-yarn-patterns");
/**
 * Find every glob pattern which should be used to find package.json files for
 * this monorepo.
 */
function getPatterns(io, config) {
    return (0, effect_1.pipe)(getCliPatterns(), effect_1.Effect.flatMap((opt) => (effect_1.Option.isSome(opt) ? effect_1.Effect.succeed(opt) : getWorkspacePatterns())), effect_1.Effect.map(effect_1.Option.map(limitToPackageJson)), effect_1.Effect.map(effect_1.Option.getOrElse(() => [...constants_1.DEFAULT_CONFIG.source])));
    function getCliPatterns() {
        return (0, effect_1.pipe)(effect_1.Option.some((0, get_source_1.getSource)(config)), effect_1.Option.filter(is_array_of_strings_1.isArrayOfStrings), effect_1.Effect.succeed);
    }
    function getWorkspacePatterns() {
        return (0, effect_1.pipe)((0, get_yarn_patterns_1.getYarnPatterns)(io), effect_1.Effect.flatMap((opt) => (effect_1.Option.isSome(opt) ? effect_1.Effect.succeed(opt) : (0, get_pnpm_patterns_1.getPnpmPatterns)(io))), effect_1.Effect.flatMap((opt) => (effect_1.Option.isSome(opt) ? effect_1.Effect.succeed(opt) : (0, get_lerna_patterns_1.getLernaPatterns)(io))), effect_1.Effect.map(effect_1.Option.map((patterns) => ['package.json', ...patterns])));
    }
    function limitToPackageJson(patterns) {
        return patterns.map((pattern) => pattern.includes('package.json') ? pattern : `${pattern}/package.json`);
    }
}
exports.getPatterns = getPatterns;
