"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getYarnPatterns = void 0;
const effect_1 = require("effect");
const path_1 = require("path");
const is_array_of_strings_1 = require("tightrope/guard/is-array-of-strings");
const is_non_empty_object_1 = require("tightrope/guard/is-non-empty-object");
const read_json_file_sync_1 = require("../../io/read-json-file-sync");
function getYarnPatterns(io) {
    return (0, effect_1.pipe)((0, read_json_file_sync_1.readJsonFileSync)(io, (0, path_1.join)(io.process.cwd(), 'package.json')), effect_1.Effect.map((file) => (0, is_non_empty_object_1.isNonEmptyObject)(file.contents.workspaces) &&
        (0, is_array_of_strings_1.isArrayOfStrings)(file.contents.workspaces.packages)
        ? effect_1.Option.some(file.contents.workspaces.packages)
        : (0, is_array_of_strings_1.isArrayOfStrings)(file.contents.workspaces)
            ? effect_1.Option.some(file.contents.workspaces)
            : effect_1.Option.none()), effect_1.Effect.catchTags({
        ReadFileError: () => effect_1.Effect.succeed(effect_1.Option.none()),
        JsonParseError: () => effect_1.Effect.succeed(effect_1.Option.none()),
    }));
}
exports.getYarnPatterns = getYarnPatterns;
