"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPnpmPatterns = void 0;
const effect_1 = require("effect");
const path_1 = require("path");
const is_array_of_strings_1 = require("tightrope/guard/is-array-of-strings");
const read_yaml_file_sync_1 = require("../../io/read-yaml-file-sync");
function getPnpmPatterns(io) {
    return (0, effect_1.pipe)(
    // packages:
    //   - "packages/**"
    //   - "components/**"
    //   - "!**/test/**"
    (0, read_yaml_file_sync_1.readYamlFileSync)(io, (0, path_1.join)(io.process.cwd(), 'pnpm-workspace.yaml')), effect_1.Effect.map((file) => ((0, is_array_of_strings_1.isArrayOfStrings)(file?.packages) ? effect_1.Option.some(file.packages) : effect_1.Option.none())), effect_1.Effect.catchTags({
        ReadYamlFileError: () => effect_1.Effect.succeed(effect_1.Option.none()),
    }));
}
exports.getPnpmPatterns = getPnpmPatterns;
