"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLernaPatterns = void 0;
const effect_1 = require("effect");
const path_1 = require("path");
const is_array_of_strings_1 = require("tightrope/guard/is-array-of-strings");
const read_json_file_sync_1 = require("../../io/read-json-file-sync");
function getLernaPatterns(io) {
    return (0, effect_1.pipe)((0, read_json_file_sync_1.readJsonFileSync)(io, (0, path_1.join)(io.process.cwd(), 'lerna.json')), effect_1.Effect.map((file) => (0, is_array_of_strings_1.isArrayOfStrings)(file.contents.packages) ? effect_1.Option.some(file.contents.packages) : effect_1.Option.none()), effect_1.Effect.catchTags({
        ReadFileError: () => effect_1.Effect.succeed(effect_1.Option.none()),
        JsonParseError: () => effect_1.Effect.succeed(effect_1.Option.none()),
    }));
}
exports.getLernaPatterns = getLernaPatterns;
