"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getFilePaths = exports.NoSourcesFoundError = void 0;
const effect_1 = require("effect");
const uniq_1 = require("tightrope/array/uniq");
const is_non_empty_array_1 = require("tightrope/guard/is-non-empty-array");
const glob_sync_1 = require("../io/glob-sync");
const get_patterns_1 = require("./get-patterns");
class NoSourcesFoundError extends effect_1.Data.TaggedClass('NoSourcesFoundError') {
}
exports.NoSourcesFoundError = NoSourcesFoundError;
/**
 * Using --source options and/or config files on disk from
 * npm/pnpm/yarn/lerna, return an array of absolute paths to every package.json
 * file the user is working with.
 *
 * @returns Array of absolute file paths to package.json files
 */
function getFilePaths(io, config) {
    return (0, effect_1.pipe)(effect_1.Effect.Do, effect_1.Effect.bind('patterns', () => (0, get_patterns_1.getPatterns)(io, config)), effect_1.Effect.bind('filePaths', ({ patterns }) => (0, glob_sync_1.globSync)(io, patterns)), effect_1.Effect.bind('flatFilePaths', ({ filePaths }) => effect_1.Effect.sync(() => (0, uniq_1.uniq)(filePaths.flat()))), effect_1.Effect.flatMap(({ flatFilePaths, patterns }) => (0, is_non_empty_array_1.isNonEmptyArray)(flatFilePaths)
        ? effect_1.Effect.succeed(flatFilePaths)
        : effect_1.Effect.fail(new NoSourcesFoundError({
            CWD: io.process.cwd(),
            patterns,
        }))));
}
exports.getFilePaths = getFilePaths;
