"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getContext = void 0;
const effect_1 = require("effect");
const get_package_json_files_1 = require("../get-package-json-files");
const read_config_file_sync_1 = require("../io/read-config-file-sync");
const key_by_1 = require("./lib/key-by");
function getContext({ io, cli, errorHandlers }) {
    const exitOnError = effect_1.Effect.flatMap(() => effect_1.Effect.failSync(() => io.process.exit(1)));
    return (0, effect_1.pipe)(effect_1.Effect.Do, effect_1.Effect.bind('rcFile', () => (0, read_config_file_sync_1.readConfigFileSync)(io, cli.configPath)), effect_1.Effect.bind('packageJsonFiles', ({ rcFile }) => (0, get_package_json_files_1.getPackageJsonFiles)(io, { cli, rcFile })), effect_1.Effect.map(({ rcFile, packageJsonFiles }) => ({
        config: { cli, rcFile },
        isInvalid: false,
        packageJsonFiles,
        packageJsonFilesByName: (0, key_by_1.keyBy)('name', packageJsonFiles),
    })), effect_1.Effect.catchTags({
        GlobError: (0, effect_1.flow)(errorHandlers.GlobError, exitOnError),
        JsonParseError: (0, effect_1.flow)(errorHandlers.JsonParseError, exitOnError),
        NoSourcesFoundError: (0, effect_1.flow)(errorHandlers.NoSourcesFoundError, exitOnError),
        ReadFileError: (0, effect_1.flow)(errorHandlers.ReadFileError, exitOnError),
    }));
}
exports.getContext = getContext;
