import { Effect } from 'effect';
import type { O } from 'ts-toolbelt';
import { type CliConfig, type RcConfig } from '../config/types';
import type { ErrorHandlers } from '../error-handlers/default-error-handlers';
import type { PackageJsonFile } from '../get-package-json-files/package-json-file';
import type { Io } from '../io';
export interface Ctx {
    readonly config: {
        readonly cli: Partial<CliConfig>;
        readonly rcFile: O.Partial<RcConfig, 'deep'>;
    };
    /** @TODO: Replace with Effect Exit/Cause */
    isInvalid: boolean;
    packageJsonFiles: PackageJsonFile[];
    packageJsonFilesByName: Record<string, PackageJsonFile>;
}
interface Input {
    io: Io;
    cli: Partial<CliConfig>;
    errorHandlers: ErrorHandlers;
}
export declare function getContext({ io, cli, errorHandlers }: Input): Effect.Effect<never, never, Ctx>;
export {};
