"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultErrorHandlers = void 0;
const chalk_1 = __importDefault(require("chalk"));
const effect_1 = require("effect");
const os_1 = require("os");
exports.defaultErrorHandlers = {
    // getContext
    GlobError(err) {
        return effect_1.Effect.logError([
            chalk_1.default.red('An error was found when processing your source globs'),
            chalk_1.default.red('  Error:', err.error),
        ].join(os_1.EOL));
    },
    JsonParseError(err) {
        return effect_1.Effect.logError([
            chalk_1.default.red('An error was found when parsing a JSON file'),
            chalk_1.default.red('  File:', err.filePath),
            chalk_1.default.red('  Error:', err.error),
        ].join(os_1.EOL));
    },
    NoSourcesFoundError(err) {
        return effect_1.Effect.logError([
            chalk_1.default.red('No package.json files were found'),
            chalk_1.default.red('  CWD:', err.CWD),
            chalk_1.default.red('  Sources:', err.patterns),
        ].join(os_1.EOL));
    },
    ReadFileError(err) {
        return effect_1.Effect.logError([
            chalk_1.default.red('An error was found when reading a file'),
            chalk_1.default.red('  File:', err.filePath),
            chalk_1.default.red('  Error:', err.error),
        ].join(os_1.EOL));
    },
    // Others
    DeprecatedTypesError(err) {
        const url = 'https://github.com/JamieMason/syncpack/releases/tag/9.0.0';
        return effect_1.Effect.logError([
            chalk_1.default.red(`Your syncpack config file contains values deprecated in ${url}`),
            chalk_1.default.red('  Dependency Types:', err.types),
            chalk_1.default.red('  Docs: https://jamiemason.github.io/syncpack/config/dependency-types'),
        ].join(os_1.EOL));
    },
    InvalidCustomTypeError(err) {
        return effect_1.Effect.logError([
            chalk_1.default.red('Your syncpack config file contains an invalid custom type'),
            chalk_1.default.red('  Error:', err.reason),
            chalk_1.default.red('  Config:', err.config),
            chalk_1.default.red('  Docs: https://jamiemason.github.io/syncpack/config/custom-types'),
        ].join(os_1.EOL));
    },
    RenamedWorkspaceTypeError() {
        const url = 'https://github.com/JamieMason/syncpack/releases/tag/11.2.1';
        return effect_1.Effect.logError([
            chalk_1.default.red(`The "workspace" dependency type was renamed to "local" in ${url}`),
            chalk_1.default.red('  Docs: https://jamiemason.github.io/syncpack/config/dependency-types'),
        ].join(os_1.EOL));
    },
    SemverGroupConfigError(err) {
        return effect_1.Effect.logError([
            chalk_1.default.red('Your semver group config contains an error'),
            chalk_1.default.red('  Error:', err.error),
            chalk_1.default.red('  Config:', err.config),
            chalk_1.default.red('  Docs: https://jamiemason.github.io/syncpack/config/semver-groups'),
        ].join(os_1.EOL));
    },
    VersionGroupConfigError(err) {
        return effect_1.Effect.logError([
            chalk_1.default.red('Your version group config contains an error'),
            chalk_1.default.red('  Error:', err.error),
            chalk_1.default.red('  Config:', err.config),
            chalk_1.default.red('  Docs: https://jamiemason.github.io/syncpack/config/version-groups'),
        ].join(os_1.EOL));
    },
    WriteFileError(err) {
        return effect_1.Effect.logError([
            chalk_1.default.red('An error was found when writing to a file'),
            chalk_1.default.red('  File:', err.filePath),
            chalk_1.default.red('  Error:', err.error),
        ].join(os_1.EOL));
    },
};
