import { Effect } from 'effect';
import type { InvalidCustomTypeError } from '../config/get-custom-types';
import type { DeprecatedTypesError, RenamedWorkspaceTypeError } from '../config/get-enabled-types';
import type { NoSourcesFoundError } from '../get-package-json-files/get-file-paths';
import type { GlobError } from '../io/glob-sync';
import type { ReadFileError } from '../io/read-file-sync';
import type { JsonParseError } from '../io/read-json-file-sync';
import type { WriteFileError } from '../io/write-file-sync';
import type { SemverGroup } from '../semver-group';
import type { VersionGroup } from '../version-group';
type R = Effect.Effect<never, never, void>;
export interface ErrorHandlers {
    DeprecatedTypesError(err: DeprecatedTypesError): R;
    InvalidCustomTypeError(err: InvalidCustomTypeError): R;
    RenamedWorkspaceTypeError(err: RenamedWorkspaceTypeError): R;
    SemverGroupConfigError(err: SemverGroup.ConfigError): R;
    VersionGroupConfigError(err: VersionGroup.ConfigError): R;
    GlobError(err: GlobError): R;
    JsonParseError(err: JsonParseError): R;
    NoSourcesFoundError(err: NoSourcesFoundError): R;
    ReadFileError(err: ReadFileError): R;
    WriteFileError(err: WriteFileError): R;
}
export declare const defaultErrorHandlers: ErrorHandlers;
export {};
