"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSortFirst = void 0;
const is_array_of_strings_1 = require("tightrope/guard/is-array-of-strings");
const is_empty_array_1 = require("tightrope/guard/is-empty-array");
const constants_1 = require("../constants");
function getSortFirst({ rcFile }) {
    return (0, is_array_of_strings_1.isArrayOfStrings)(rcFile.sortFirst) || (0, is_empty_array_1.isEmptyArray)(rcFile.sortFirst)
        ? rcFile.sortFirst
        : constants_1.DEFAULT_CONFIG.sortFirst;
}
exports.getSortFirst = getSortFirst;
