"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSortExports = void 0;
const is_array_of_strings_1 = require("tightrope/guard/is-array-of-strings");
const is_empty_array_1 = require("tightrope/guard/is-empty-array");
const constants_1 = require("../constants");
function getSortExports({ rcFile }) {
    return (0, is_array_of_strings_1.isArrayOfStrings)(rcFile.sortExports) || (0, is_empty_array_1.isEmptyArray)(rcFile.sortExports)
        ? rcFile.sortExports
        : constants_1.DEFAULT_CONFIG.sortExports;
}
exports.getSortExports = getSortExports;
