"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSortAz = void 0;
const is_array_of_strings_1 = require("tightrope/guard/is-array-of-strings");
const is_empty_array_1 = require("tightrope/guard/is-empty-array");
const constants_1 = require("../constants");
function getSortAz({ rcFile }) {
    return (0, is_array_of_strings_1.isArrayOfStrings)(rcFile.sortAz) || (0, is_empty_array_1.isEmptyArray)(rcFile.sortAz)
        ? rcFile.sortAz
        : constants_1.DEFAULT_CONFIG.sortAz;
}
exports.getSortAz = getSortAz;
