"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getIndent = void 0;
const is_non_empty_string_1 = require("tightrope/guard/is-non-empty-string");
const constants_1 = require("../constants");
function getIndent({ cli, rcFile }) {
    return (0, is_non_empty_string_1.isNonEmptyString)(cli.indent)
        ? cli.indent.replaceAll('\\t', '\t')
        : (0, is_non_empty_string_1.isNonEmptyString)(rcFile.indent)
            ? rcFile.indent
            : constants_1.DEFAULT_CONFIG.indent;
}
exports.getIndent = getIndent;
