"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.update = void 0;
const chalk_1 = __importDefault(require("chalk"));
const effect_1 = require("effect");
const semver_1 = require("semver");
const tag_1 = require("../config/tag");
const constants_1 = require("../constants");
const default_error_handlers_1 = require("../error-handlers/default-error-handlers");
const get_context_1 = require("../get-context");
const get_instances_1 = require("../get-instances");
const io_1 = require("../io");
const exit_if_invalid_1 = require("../io/exit-if-invalid");
const write_if_changed_1 = require("../io/write-if-changed");
const with_logger_1 = require("../lib/with-logger");
const specifier_1 = require("../specifier");
const effects_1 = require("./effects");
function update(io, cli, effects = effects_1.updateEffects, errorHandlers = default_error_handlers_1.defaultErrorHandlers) {
    return (0, effect_1.pipe)(effect_1.Effect.Do, effect_1.Effect.bind('ctx', () => (0, get_context_1.getContext)({ io, cli, errorHandlers })), effect_1.Effect.bind('instances', ({ ctx }) => (0, get_instances_1.getInstances)(ctx, io, errorHandlers)), effect_1.Effect.bind('update', ({ instances }) => (0, effect_1.pipe)(effect_1.Effect.succeed(instances.all), effect_1.Effect.map((instances) => {
        const isVisitedByName = {};
        const updateable = [];
        instances.forEach((instance) => {
            if (!isVisitedByName[instance.name] &&
                (instance.versionGroup._tag === 'SameRange' ||
                    instance.versionGroup._tag === 'Standard')) {
                const specifier = specifier_1.Specifier.create(instance, instance.rawSpecifier.raw);
                if (specifier._tag === 'Range' || specifier._tag === 'Exact') {
                    isVisitedByName[instance.name] = true;
                    updateable.push(instance);
                }
            }
        });
        return updateable;
    }), effect_1.Effect.tap(effects_1.updateEffects.onFetchAllStart), effect_1.Effect.flatMap((instances) => (0, effect_1.pipe)(instances, effect_1.Effect.partition((instance) => (0, effect_1.pipe)(effect_1.Effect.succeed(instance), effect_1.Effect.tap(() => effects_1.updateEffects.onFetchStart(instance, instances.length)), effect_1.Effect.flatMap(effects.fetchLatestVersions), effect_1.Effect.tapBoth({
        onFailure: () => effects_1.updateEffects.onFetchEnd(instance),
        onSuccess: ({ versions }) => effects_1.updateEffects.onFetchEnd(instance, versions),
    }), 
    // move up to date dependencies to error channel
    effect_1.Effect.flatMap((updateable) => (0, semver_1.gtr)(updateable.versions.latest, String(instance.rawSpecifier.raw))
        ? (0, effect_1.pipe)(effects_1.updateEffects.onOutdated(instance, updateable.versions.latest), effect_1.Effect.map(() => updateable))
        : (0, effect_1.pipe)(effects_1.updateEffects.onUpToDate(instance), effect_1.Effect.flatMap(() => effect_1.Effect.fail(updateable)))), 
    // log error but don't catch it
    effect_1.Effect.tapErrorTag('HttpError', ({ error }) => effect_1.Effect.logError((0, chalk_1.default) `{red ${constants_1.ICON.cross} ${error}}`)), 
    // log error but don't catch it
    effect_1.Effect.tapErrorTag('NpmRegistryError', ({ error }) => effect_1.Effect.logError((0, chalk_1.default) `{red ${constants_1.ICON.cross} ${error}}`))), { concurrency: 10 }), 
    // discard errors and up to date dependencies
    effect_1.Effect.flatMap(([_, outOfDate]) => effect_1.Effect.succeed(outOfDate)))), 
    // always remove the spinner when we're done
    effect_1.Effect.tapBoth({
        onFailure: effects_1.updateEffects.onFetchAllEnd,
        onSuccess: effects_1.updateEffects.onFetchAllEnd,
    }), 
    // ask the user which updates they want
    effect_1.Effect.flatMap(effects_1.updateEffects.promptForUpdates), 
    // if we think the user cancelled, say so
    effect_1.Effect.catchTag('PromptCancelled', () => effect_1.Effect.logInfo((0, chalk_1.default) `{red ${constants_1.ICON.panic}} aborting after {blue syncpack update} was cancelled`)))), effect_1.Effect.flatMap(({ ctx }) => (0, effect_1.pipe)((0, write_if_changed_1.writeIfChanged)(ctx), effect_1.Effect.catchTags({
        WriteFileError: (0, effect_1.flow)(errorHandlers.WriteFileError, effect_1.Effect.map(() => {
            ctx.isInvalid = true;
            return ctx;
        })),
    }))), effect_1.Effect.flatMap(exit_if_invalid_1.exitIfInvalid), effect_1.Effect.withConcurrency(10), effect_1.Effect.provide((0, effect_1.pipe)(effect_1.Context.empty(), effect_1.Context.add(tag_1.CliConfigTag, cli), effect_1.Context.add(io_1.IoTag, io))), with_logger_1.withLogger);
}
exports.update = update;
