"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateEffects = void 0;
const Schema = __importStar(require("@effect/schema/Schema"));
const chalk_1 = __importDefault(require("chalk"));
const effect_1 = require("effect");
const https_1 = __importDefault(require("https"));
const ora_1 = __importDefault(require("ora"));
const os_1 = require("os");
const prompts_1 = __importDefault(require("prompts"));
const semver_1 = require("semver");
const gtr_1 = __importDefault(require("semver/ranges/gtr"));
const is_array_1 = require("tightrope/guard/is-array");
const is_empty_object_1 = require("tightrope/guard/is-empty-object");
const constants_1 = require("../constants");
const format_repository_url_1 = require("../lib/format-repository-url");
const ring_buffer_1 = require("../lib/ring-buffer");
const set_semver_range_1 = require("../lib/set-semver-range");
const specifier_1 = require("../specifier");
/** full release history from the npm registry for a given package */
class Releases extends effect_1.Data.TaggedClass('Releases') {
}
// https://github.com/terkelg/prompts?tab=readme-ov-file#prompts
class PromptCancelled extends effect_1.Data.TaggedClass('PromptCancelled') {
}
class HttpError extends effect_1.Data.TaggedClass('HttpError') {
}
class NpmRegistryError extends effect_1.Data.TaggedClass('NpmRegistryError') {
}
/** the API client for the terminal spinner */
let spinner = null;
/** how many HTTP requests have been sent */
let fetchedCount = 0;
/** how many instances have updates available */
let outdatedCount = 0;
/** names of instances currently being fetched from npm */
const inFlight = new Set();
/** names of instances most recently finished being fetched from npm */
const mostRecent = new ring_buffer_1.RingBuffer(5);
/** page size when prompting */
const optionsPerPage = 50;
/** instance names in `inFlight` are formatted for display */
function format(instance) {
    return (0, chalk_1.default) `{gray ${instance.name}}`;
}
/** we need to remove colours when sorting loading status output */
function stripAnsi(str) {
    // eslint-disable-next-line no-control-regex
    const ansiChars = /[\u001b\u009b][[()#;?]*(?:[0-9]{1,4}(?:;[0-9]{0,4})*)?[0-9A-ORZcf-nqry=><]/g;
    return str.replace(ansiChars, '');
}
exports.updateEffects = {
    onFetchAllStart() {
        if (!spinner)
            spinner = (0, ora_1.default)().start();
        fetchedCount = 0;
        return effect_1.Effect.unit;
    },
    onFetchStart(instance, totalCount) {
        inFlight.add(format(instance));
        fetchedCount++;
        if (spinner) {
            const indent = `${os_1.EOL}  `;
            const progress = new Set([...mostRecent.filter(Boolean), ...inFlight.values()]);
            const sortedProgress = Array.from(progress).sort((a, b) => stripAnsi(a).localeCompare(stripAnsi(b)));
            const suffixText = sortedProgress.join(indent);
            spinner.text = (0, chalk_1.default) `${outdatedCount} updates found in ${fetchedCount}/${totalCount} dependencies${indent}${suffixText}`;
        }
        return effect_1.Effect.unit;
    },
    onFetchEnd(instance, versions) {
        inFlight.delete(format(instance));
        const latest = versions?.latest;
        if (latest) {
            if ((0, gtr_1.default)(latest, String(instance.rawSpecifier.raw), true)) {
                outdatedCount++;
                mostRecent.push((0, chalk_1.default) `${instance.name} {gray {red ${instance.rawSpecifier.raw}} ${constants_1.ICON.rightArrow}} {green ${latest}}`);
            }
            else {
                mostRecent.push((0, chalk_1.default) `{green ${instance.name}}`);
            }
        }
        return effect_1.Effect.unit;
    },
    /** After checking the registry, store this instance known to be up to date */
    onUpToDate(instance) {
        mostRecent.push((0, chalk_1.default) `{green ${instance.name}}`);
        return effect_1.Effect.unit;
    },
    /** After checking the registry, store this instance known to have newer versions available */
    onOutdated(instance, latest) {
        outdatedCount++;
        mostRecent.push((0, chalk_1.default) `${instance.name} {gray {red ${instance.rawSpecifier.raw}} ${constants_1.ICON.rightArrow}} {green ${latest}}`);
        return effect_1.Effect.unit;
    },
    /** As the last request completes, remove the progress information */
    onFetchAllEnd() {
        if (spinner)
            spinner.stop();
        spinner = null;
        fetchedCount = 0;
        return effect_1.Effect.unit;
    },
    /** Fetch available versions for a given package from the npm registry */
    fetchLatestVersions(instance) {
        return (0, effect_1.pipe)(fetchJson(`https://registry.npmjs.org/${instance.name}`), 
        // parse and validate the specific data we expect
        effect_1.Effect.flatMap(Schema.parse(Schema.struct({
            'dist-tags': Schema.struct({ latest: Schema.string }),
            'time': Schema.record(Schema.string, Schema.string),
            'homepage': Schema.optional(Schema.string),
            'repository': Schema.optional(Schema.union(Schema.string, Schema.struct({ url: Schema.optional(Schema.string) }))),
        }))), 
        // transform it into something more appropriate
        effect_1.Effect.map((struct) => {
            const rawRepoUrl = typeof struct.repository === 'object' ? struct.repository.url : struct.repository;
            return new Releases({
                instance,
                versions: {
                    all: Object.keys(struct.time).filter((key) => key !== 'modified' && key !== 'created'),
                    latest: struct['dist-tags'].latest,
                },
                repoUrl: (0, format_repository_url_1.formatRepositoryUrl)(rawRepoUrl),
            });
        }), 
        // hide ParseErrors and just treat them as another kind of NpmRegistryError
        effect_1.Effect.catchTags({
            ParseError: () => effect_1.Effect.fail(new NpmRegistryError({ error: `Invalid response for ${instance.name}` })),
        }));
    },
    /** Given responses from npm, ask the user which they want */
    promptForUpdates(outdated) {
        return (0, effect_1.pipe)(effect_1.Effect.Do, effect_1.Effect.bind('releasesByType', () => groupByReleaseType(outdated)), 
        // Create choices to ask if they want major, minor, patch etc
        effect_1.Effect.bind('releaseTypeQuestions', ({ releasesByType }) => effect_1.Effect.succeed(Object.keys(releasesByType)
            .filter((type) => releasesByType[type].length > 0)
            .map((type) => ({
            title: (0, chalk_1.default) `${releasesByType[type].length} ${type}`,
            selected: true,
            value: type,
        })))), 
        // Ask which release types (major, minor, patch etc) they want
        effect_1.Effect.bind('releaseTypeAnswers', ({ releaseTypeQuestions }) => releaseTypeQuestions.length > 0
            ? (0, effect_1.pipe)(effect_1.Effect.tryPromise({
                try: () => (0, prompts_1.default)({
                    name: 'releaseTypeAnswers',
                    type: 'multiselect',
                    instructions: true,
                    message: `${outdated.length} updates are available`,
                    choices: releaseTypeQuestions,
                }).then((res) => res?.releaseTypeAnswers || []),
                catch: effect_1.identity,
            }), effect_1.Effect.catchAll(() => (0, effect_1.pipe)(effect_1.Effect.logError('Error when prompting for releaseTypeAnswers'), effect_1.Effect.map(() => []))))
            : effect_1.Effect.succeed([])), 
        // For each chosen release type, list the available updates to choose from
        effect_1.Effect.bind('prepatchAnswers', (doState) => promptForReleaseType('prepatch', doState)), effect_1.Effect.bind('patchAnswers', (doState) => promptForReleaseType('patch', doState)), effect_1.Effect.bind('preminorAnswers', (doState) => promptForReleaseType('preminor', doState)), effect_1.Effect.bind('minorAnswers', (doState) => promptForReleaseType('minor', doState)), effect_1.Effect.bind('premajorAnswers', (doState) => promptForReleaseType('premajor', doState)), effect_1.Effect.bind('majorAnswers', (doState) => promptForReleaseType('major', doState)), effect_1.Effect.bind('prereleaseAnswers', (doState) => promptForReleaseType('prerelease', doState)), 
        /** Apply every update to the package.json files */
        effect_1.Effect.flatMap((doState) => (0, effect_1.pipe)([
            ...doState.prepatchAnswers,
            ...doState.patchAnswers,
            ...doState.preminorAnswers,
            ...doState.minorAnswers,
            ...doState.premajorAnswers,
            ...doState.majorAnswers,
            ...doState.prereleaseAnswers,
        ], effect_1.Effect.forEach(({ instance, versions }) => (0, effect_1.pipe)(instance.semverGroup.getFixed(specifier_1.Specifier.create(instance, versions.latest)), effect_1.Effect.flatMap((latestWithRange) => instance.write(latestWithRange.raw)), effect_1.Effect.catchTag('NonSemverError', effect_1.Effect.logError))), effect_1.Effect.flatMap(() => effect_1.Effect.unit))));
    },
};
function promptForReleaseType(releaseType, doState) {
    const { releasesByType, releaseTypeAnswers } = doState;
    const prop = `${releaseType}Answers`;
    const releases = releasesByType[releaseType];
    return releaseTypeAnswers.includes(releaseType)
        ? (0, effect_1.pipe)(effect_1.Effect.tryPromise({
            try: () => (0, prompts_1.default)({
                name: prop,
                type: 'multiselect',
                instructions: false,
                // @ts-expect-error optionsPerPage *does* exist https://github.com/terkelg/prompts#options-7
                optionsPerPage,
                message: `${releases.length} ${releaseType} updates`,
                choices: releases.map((updateable) => {
                    const spacingValue = 50 -
                        updateable.instance.name.length -
                        String(updateable.instance.rawSpecifier).length -
                        updateable.versions.latest.length;
                    const spacing = Array.from({ length: spacingValue }).fill(' ').join('');
                    const repoUrl = updateable.repoUrl
                        ? (0, chalk_1.default) `${spacing} {white - ${updateable.repoUrl}}`
                        : '';
                    return {
                        title: (0, chalk_1.default) `${updateable.instance.name} {gray ${updateable.instance.rawSpecifier.raw} ${constants_1.ICON.rightArrow}} {green ${updateable.versions.latest}} ${repoUrl}`,
                        selected: true,
                        value: updateable,
                    };
                }),
            }),
            catch: effect_1.identity,
        }), 
        // Paper over errors in terkelg/prompts for now
        effect_1.Effect.catchAll(() => (0, effect_1.pipe)(effect_1.Effect.logError(`terkelg/prompts errored while prompting for ${prop}`), effect_1.Effect.map(() => ({ [prop]: [] })))), 
        // In terkelg/prompts, an empty object means that the user cancelled via
        // ctrl+c or the escape key etc. Handle this case so we can skip any
        // remaining steps.
        effect_1.Effect.flatMap((res) => (0, is_empty_object_1.isEmptyObject)(res)
            ? effect_1.Effect.fail(new PromptCancelled({ name: releaseType }))
            : effect_1.Effect.succeed((0, is_array_1.isArray)(res?.[prop]) ? res?.[prop] : [])))
        : effect_1.Effect.succeed([]);
}
function groupByReleaseType(releases) {
    return effect_1.Effect.succeed(releases.reduce((releasesByType, release) => {
        const previous = (0, set_semver_range_1.setSemverRange)('', String(release.instance.rawSpecifier.raw));
        const latest = release.versions.latest;
        try {
            const type = (0, semver_1.diff)(previous, latest);
            if (type && releasesByType[type]) {
                releasesByType[type].push(release);
            }
        }
        catch {
            //
        }
        return releasesByType;
    }, {
        prepatch: [],
        patch: [],
        preminor: [],
        minor: [],
        premajor: [],
        major: [],
        prerelease: [],
    }));
}
// @TODO: add a cache with a short TTL on disk in $TMPDIR
function fetchJson(url) {
    return (0, effect_1.pipe)(effect_1.Effect.async((resume) => {
        // setTimeout(
        //   () => {
        //     resume(
        //       Effect.succeed(
        //         JSON.stringify({
        //           'dist-tags': { latest: '3.1.1' },
        //           'time': {
        //             '0.3.1': new Date().toJSON(),
        //           },
        //         }),
        //       ),
        //     );
        //   },
        //   Math.floor(Math.random() * 500) + 1,
        // );
        https_1.default
            .get(url, (res) => {
            let body = '';
            res.setEncoding('utf8');
            res.on('data', (chunk) => {
                body = `${body}${chunk}`;
            });
            res.on('end', () => {
                resume(effect_1.Effect.succeed(body));
            });
        })
            .on('error', (err) => {
            resume(effect_1.Effect.fail(new HttpError({ error: `Node https threw on ${url}: ${String(err)}` })));
        });
    }), effect_1.Effect.flatMap((body) => effect_1.Effect.try({
        try: () => JSON.parse(body),
        catch: () => new NpmRegistryError({ error: `JSON.parse threw on response from ${url}` }),
    })));
}
