import { Data, Effect } from 'effect';
import type { Instance } from '../get-instances/instance';
declare const Releases_base: new <A extends Record<string, any> = {}>(args: import("effect/Types").Equals<Omit<A, keyof import("effect/Equal").Equal>, {}> extends true ? void : { readonly [P in keyof A as P extends "_tag" | keyof import("effect/Equal").Equal ? never : P]: A[P]; }) => Data.Data<Readonly<A> & {
    readonly _tag: "Releases";
}>;
/** full release history from the npm registry for a given package */
declare class Releases extends Releases_base<{
    instance: Instance;
    versions: {
        all: string[];
        latest: string;
    };
    repoUrl: string | undefined;
}> {
}
declare const PromptCancelled_base: new <A extends Record<string, any> = {}>(args: import("effect/Types").Equals<Omit<A, keyof import("effect/Equal").Equal>, {}> extends true ? void : { readonly [P in keyof A as P extends "_tag" | keyof import("effect/Equal").Equal ? never : P]: A[P]; }) => Data.Data<Readonly<A> & {
    readonly _tag: "PromptCancelled";
}>;
declare class PromptCancelled extends PromptCancelled_base<{
    name: string;
}> {
}
declare const HttpError_base: new <A extends Record<string, any> = {}>(args: import("effect/Types").Equals<Omit<A, keyof import("effect/Equal").Equal>, {}> extends true ? void : { readonly [P in keyof A as P extends "_tag" | keyof import("effect/Equal").Equal ? never : P]: A[P]; }) => Data.Data<Readonly<A> & {
    readonly _tag: "HttpError";
}>;
declare class HttpError extends HttpError_base<{
    error: string;
}> {
}
declare const NpmRegistryError_base: new <A extends Record<string, any> = {}>(args: import("effect/Types").Equals<Omit<A, keyof import("effect/Equal").Equal>, {}> extends true ? void : { readonly [P in keyof A as P extends "_tag" | keyof import("effect/Equal").Equal ? never : P]: A[P]; }) => Data.Data<Readonly<A> & {
    readonly _tag: "NpmRegistryError";
}>;
declare class NpmRegistryError extends NpmRegistryError_base<{
    error: string;
}> {
}
export declare const updateEffects: {
    onFetchAllStart(): Effect.Effect<never, never, void>;
    onFetchStart(instance: Instance, totalCount: number): Effect.Effect<never, never, void>;
    onFetchEnd(instance: Instance, versions?: Releases['versions']): Effect.Effect<never, never, void>;
    /** After checking the registry, store this instance known to be up to date */
    onUpToDate(instance: Instance): Effect.Effect<never, never, void>;
    /** After checking the registry, store this instance known to have newer versions available */
    onOutdated(instance: Instance, latest: string): Effect.Effect<never, never, void>;
    /** As the last request completes, remove the progress information */
    onFetchAllEnd(): Effect.Effect<never, never, void>;
    /** Fetch available versions for a given package from the npm registry */
    fetchLatestVersions(instance: Instance): Effect.Effect<never, HttpError | NpmRegistryError, Releases>;
    /** Given responses from npm, ask the user which they want */
    promptForUpdates(outdated: Releases[]): Effect.Effect<never, PromptCancelled, void>;
};
export {};
