#!/usr/bin/env node
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const chalk_1 = __importDefault(require("chalk"));
const commander_1 = require("commander");
const effect_1 = require("effect");
const io_1 = require("../io");
const show_help_on_error_1 = require("../lib/show-help-on-error");
const option_1 = require("../option");
const prompt_1 = require("./prompt");
commander_1.program.description('  displays a series of prompts to fix mismatches which syncpack cannot fix automatically');
commander_1.program.on('--help', () => {
    console.log((0, chalk_1.default) `
  Examples:
  {dim # uses defaults for resolving packages}
  syncpack prompt
  {dim # uses packages defined by --source when provided}
  syncpack prompt --source {yellow "apps/*/package.json"}
  {dim # multiple globs can be provided like this}
  syncpack prompt --source {yellow "apps/*/package.json"} --source {yellow "core/*/package.json"}
  {dim # uses dependencies regular expression defined by --filter when provided}
  syncpack prompt --filter {yellow "typescript|tslint"}
  {dim # only inspect "devDependencies"}
  syncpack prompt --types dev
  {dim # only inspect "devDependencies" and "peerDependencies"}
  syncpack prompt --types dev,peer
  {dim # indent package.json with 4 spaces instead of 2}
  syncpack prompt --indent {yellow "    "}

Resolving Packages:
  1. If {yellow --source} globs are provided, use those.
  2. If using Pnpm Workspaces, read {yellow packages} from {yellow pnpm-workspace.yaml} in the root of the project.
  3. If using Yarn Workspaces, read {yellow workspaces} from {yellow package.json}.
  4. If using Lerna, read {yellow packages} from {yellow lerna.json}.
  5. Default to {yellow "package.json"} and {yellow "packages/*/package.json"}.

Reference:
  globs            {blue.underline https://github.com/isaacs/node-glob#glob-primer}
  lerna.json       {blue.underline https://github.com/lerna/lerna#lernajson}
  Yarn Workspaces  {blue.underline https://yarnpkg.com/lang/en/docs/workspaces}
  Pnpm Workspaces  {blue.underline https://pnpm.js.org/en/workspaces}
`);
});
(0, show_help_on_error_1.showHelpOnError)(commander_1.program);
commander_1.program
    .option(...option_1.option.source)
    .option(...option_1.option.filter)
    .option(...option_1.option.config)
    .option(...option_1.option.specs)
    .option(...option_1.option.types)
    .option(...option_1.option.indent)
    .parse(process.argv);
effect_1.Effect.runPromise((0, prompt_1.prompt)({
    io: io_1.io,
    cli: {
        configPath: commander_1.program.opts().config,
        filter: commander_1.program.opts().filter,
        source: commander_1.program.opts().source,
        specs: commander_1.program.opts().specs,
        types: commander_1.program.opts().types,
        indent: commander_1.program.opts().indent,
    },
}));
