import { Effect } from 'effect';
import { type CliConfig } from '../config/types';
import type { ErrorHandlers } from '../error-handlers/default-error-handlers';
import type { Ctx } from '../get-context';
import type { Io } from '../io';
interface Input {
    io: Io;
    cli: Partial<CliConfig>;
    errorHandlers?: ErrorHandlers;
}
export declare function listMismatches({ io, cli, errorHandlers }: Input): Effect.Effect<never, never, unknown>;
/** Exported to be reused by `syncpack lint` */
export declare function pipeline(ctx: Ctx, io: Io, errorHandlers: ErrorHandlers): Effect.Effect<never, never, Ctx>;
export declare const logMissingLocalVersion: (report: any) => Effect.Effect<never, never, void>;
export declare const logMissingSnappedToMismatch: (report: any) => Effect.Effect<never, never, void>;
export declare const logUnsupportedMismatch: (report: any) => Effect.Effect<never, never, void>;
export declare const logSameRangeMismatch: (report: any) => Effect.Effect<never, never, void>;
export {};
