"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.lint = void 0;
const chalk_1 = __importDefault(require("chalk"));
const effect_1 = require("effect");
const format_1 = require("../bin-format/format");
const lint_semver_ranges_1 = require("../bin-lint-semver-ranges/lint-semver-ranges");
const list_mismatches_1 = require("../bin-list-mismatches/list-mismatches");
const tag_1 = require("../config/tag");
const constants_1 = require("../constants");
const default_error_handlers_1 = require("../error-handlers/default-error-handlers");
const get_context_1 = require("../get-context");
const io_1 = require("../io");
const exit_if_invalid_1 = require("../io/exit-if-invalid");
const to_json_1 = require("../io/to-json");
const with_logger_1 = require("../lib/with-logger");
function lint({ io, cli, errorHandlers = default_error_handlers_1.defaultErrorHandlers }) {
    return (0, effect_1.pipe)((0, get_context_1.getContext)({ io, cli, errorHandlers }), 
    // Versions
    effect_1.Effect.flatMap((ctx) => effect_1.Effect.gen(function* ($) {
        if (ctx.config.rcFile.lintVersions !== false) {
            yield* $(effect_1.Effect.logInfo((0, chalk_1.default) `{yellow Versions}`));
            yield* $((0, list_mismatches_1.pipeline)(ctx, io, errorHandlers));
        }
        return ctx;
    })), 
    // Semver Ranges
    effect_1.Effect.flatMap((ctx) => effect_1.Effect.gen(function* ($) {
        if (ctx.config.rcFile.lintSemverRanges !== false) {
            yield* $(effect_1.Effect.logInfo((0, chalk_1.default) `{yellow Semver Ranges}`));
            yield* $((0, lint_semver_ranges_1.pipeline)(ctx, io, errorHandlers));
        }
        return ctx;
    })), 
    // Formatting
    effect_1.Effect.flatMap((ctx) => effect_1.Effect.gen(function* ($) {
        if (ctx.config.rcFile.lintFormatting !== false) {
            yield* $(effect_1.Effect.logInfo((0, chalk_1.default) `{yellow Formatting}`));
            yield* $((0, format_1.pipeline)(ctx));
            for (const file of ctx.packageJsonFiles) {
                const nextJson = (0, to_json_1.toJson)(ctx, file);
                const hasChanged = file.jsonFile.json !== nextJson;
                const shortPath = file.jsonFile.shortPath;
                if (hasChanged) {
                    ctx.isInvalid = true;
                    yield* $(effect_1.Effect.logInfo((0, chalk_1.default) `{red ${constants_1.ICON.cross}} ${shortPath}`));
                }
                else {
                    yield* $(effect_1.Effect.logInfo((0, chalk_1.default) `{green ${constants_1.ICON.tick}} ${shortPath}`));
                }
            }
        }
        return ctx;
    })), effect_1.Effect.flatMap(exit_if_invalid_1.exitIfInvalid), effect_1.Effect.provide((0, effect_1.pipe)(effect_1.Context.empty(), effect_1.Context.add(tag_1.CliConfigTag, cli), effect_1.Context.add(io_1.IoTag, io))), with_logger_1.withLogger);
}
exports.lint = lint;
