#!/usr/bin/env node
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const chalk_1 = __importDefault(require("chalk"));
const commander_1 = require("commander");
const effect_1 = require("effect");
const io_1 = require("../io");
const show_help_on_error_1 = require("../lib/show-help-on-error");
const option_1 = require("../option");
const lint_1 = require("./lint");
commander_1.program.description('  lint all versions and ranges');
commander_1.program.on('--help', () => {
    console.log((0, chalk_1.default) `
Examples:
  {dim # uses config file for resolving packages}
  syncpack lint
  {dim # uses config file defined by --config when provided}
  syncpack lint --config {yellow ./config/.syncpackrc}

Resolving Packages:
  1. If using Pnpm Workspaces, read {yellow packages} from {yellow pnpm-workspace.yaml} in the root of the project.
  2. If using Yarn Workspaces, read {yellow workspaces} from {yellow package.json}.
  3. If using Lerna, read {yellow packages} from {yellow lerna.json}.
  4. Default to {yellow "package.json"} and {yellow "packages/*/package.json"}.

Reference:
  globs            {blue.underline https://github.com/isaacs/node-glob#glob-primer}
  lerna.json       {blue.underline https://github.com/lerna/lerna#lernajson}
  Yarn Workspaces  {blue.underline https://yarnpkg.com/lang/en/docs/workspaces}
  Pnpm Workspaces  {blue.underline https://pnpm.js.org/en/workspaces}
`);
});
(0, show_help_on_error_1.showHelpOnError)(commander_1.program);
commander_1.program.option(...option_1.option.config).parse(process.argv);
effect_1.Effect.runPromise((0, lint_1.lint)({
    io: io_1.io,
    cli: {
        configPath: commander_1.program.opts().config,
    },
}));
