import { Effect } from 'effect';
import { type CliConfig } from '../config/types';
import type { ErrorHandlers } from '../error-handlers/default-error-handlers';
import type { Ctx } from '../get-context';
import type { Io } from '../io';
interface Input {
    io: Io;
    cli: Partial<CliConfig>;
    errorHandlers?: ErrorHandlers;
}
export declare function lintSemverRanges({ io, cli, errorHandlers }: Input): Effect.Effect<never, never, unknown>;
/** Exported to be reused by `syncpack lint` */
export declare function pipeline(ctx: Ctx, io: Io, errorHandlers: ErrorHandlers): Effect.Effect<never, never, Ctx>;
export declare function logSemverGroupsDisabledWarning(): Effect.Effect<never, never, void>;
export declare function logIgnoredSize(amount: number): Effect.Effect<never, never, void>;
export {};
