import { Effect } from 'effect';
import { type CliConfig } from '../config/types';
import type { ErrorHandlers } from '../error-handlers/default-error-handlers';
import type { Io } from '../io';
import type { Report } from '../report';
interface Input {
    io: Io;
    cli: Partial<CliConfig>;
    errorHandlers?: ErrorHandlers;
}
export declare function fixMismatches({ io, cli, errorHandlers }: Input): Effect.Effect<never, never, unknown>;
export declare function fixMismatch(report: Report.Version.Fixable.Any): Effect.Effect<never, never, import("../get-package-json-files/package-json-file").PackageJsonFile>;
export declare function logAlreadyValidSize(amount: number): Effect.Effect<never, never, void>;
export declare function logFixedSize(amount: number): Effect.Effect<never, never, void>;
export declare function logUnfixableSize(amount: number): Effect.Effect<never, never, void>;
export {};
